// ==UserScript==
// @name         SeaArt 自動削除ボタン（初回はOFF・再読み込み後はON維持）
// @namespace    http://tampermonkey.net/
// @version      1.6
// @description  SeaArtページで「すべて削除」を自動クリック（初アクセスはOFF、スクリプトの再読み込みではON維持）
// @match        https://www.seaart.ai/*
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    let autoDelete = false;   // 初期は必ずOFF
    let loopTimer = null;
    let deleteCount = 0;

    // ページ起動時にフラグを確認
    if (localStorage.getItem("seaart_autoDelete_temp") === "true") {
        autoDelete = true;
        localStorage.removeItem("seaart_autoDelete_temp"); // 一度だけ有効
    }

    // 右下にボタンを追加
    const toggleBtn = document.createElement("button");
    toggleBtn.style.position = "fixed";
    toggleBtn.style.bottom = "20px";
    toggleBtn.style.right = "20px";
    toggleBtn.style.zIndex = "9999";
    toggleBtn.style.padding = "8px 14px";
    toggleBtn.style.border = "none";
    toggleBtn.style.borderRadius = "8px";
    toggleBtn.style.cursor = "pointer";
    document.body.appendChild(toggleBtn);

    // 状態反映
    function updateBtn() {
        toggleBtn.textContent = `自動削除: ${autoDelete ? "ON" : "OFF"}`;
        toggleBtn.style.background = autoDelete ? "#4CAF50" : "#f44336";
        toggleBtn.style.color = "#fff";
    }
    updateBtn();

    // ON/OFF切替
    toggleBtn.addEventListener("click", () => {
        autoDelete = !autoDelete;
        updateBtn();
        if (autoDelete) {
            startLoop();
        } else {
            stopLoop();
        }
    });

    // 定期ループを開始
    function startLoop() {
        if (loopTimer) clearInterval(loopTimer);
        loopTimer = setInterval(() => {
            if (autoDelete) {
                processNextDelete();
            }
        }, 2000);
    }

    // 定期ループを停止
    function stopLoop() {
        if (loopTimer) {
            clearInterval(loopTimer);
            loopTimer = null;
        }
    }

    // 下から4番目以降を削除
    function processNextDelete() {
        const deleteBtns = Array.from(document.querySelectorAll(".pop-btns.flex button"))
            .filter(btn => btn.innerText.includes("すべて削除"));

        if (deleteBtns.length <= 3) {
            console.log("削除対象なし（3件以下）");
            return;
        }

        const targetBtn = deleteBtns[deleteBtns.length - 4];
        if (!targetBtn) return;

        console.log("削除ボタンをクリックします");
        targetBtn.click();

        setTimeout(() => {
            const confirmBtn = document.querySelector(".easy-select-model-confirm-modal-footer .modal-footer-btn-confirm");
            if (confirmBtn) {
                console.log("確認ボタンをクリックします");
                confirmBtn.click();
                deleteCount++;

                if (deleteCount >= 6) {
                    console.log("6件削除完了 → ページを再読み込みします");
                    deleteCount = 0;
                    localStorage.setItem("seaart_autoDelete_temp", "true"); // 再開フラグを残す
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                }
            }
        }, 500);
    }

    // ページ再読み込み後もONなら続行
    window.addEventListener("load", () => {
        if (autoDelete) {
            startLoop();
        }
    });
})();
